TITLE 									{ exa073.pde }
   'Metal Rod across a Parallel Field'
SELECT
   errlim=1e-4     spectral_colors     ngrid=1
VARIABLES
   U
DEFINITIONS
   L=1	    r0=0.3     E0x=1e3
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
EQUATIONS
   div( grad( U))=0
BOUNDARIES
region 'domain'	
   start 'outer' (-L,-L)  natural ( U)=0  line to (L,-L)
   natural( U)=-E0x line to (L,L)  			{ Outward dU/dx }
   natural( U)=0 line to (-L,L)
   natural( U)=E0x   line to close   			{ Outward dU/dx }
   start 'rod' (r0,0)  					{ Cutout for rod }
   value(U)=0  arc( center=0,0) angle=360  		
PLOTS
   contour( U)     surface( U)	
   elevation( U) on 'outer'     elevation( U) on 'rod'	
   contour( Em)     vector( E) norm
   elevation( Ex) on 'outer'     elevation( Em) on 'rod'
END

